/*____________________________________________________________________________
	Copyright (C) 1999 Network Associates, Inc.
	All rights reserved.
	
	pgpDriver9x.h - PGP 95/98 VxD device driver header file
	

	$Id: pgpDriver9x.h,v 1.3 2000/03/02 15:10:25 pbj Exp $
____________________________________________________________________________*/

#ifndef	_pgpDriver9x_h
#define _pgpDriver9x_h

#define IN
#define OUT

#include "pgpCache.h"
#include "pgpInactivity.h"
#include "pgpMemLock9x.h"

#define MOUSE_SKIP				64
#define KEYBOARD_SKIP			16

#define MOUSE_DEVICE_NAME		L"\\Device\\PointerClass0"
#define KBD_DEVICE_NAME			L"\\Device\\KeyboardClass0"

#define	PGPUTIL_DEV				0x0000
#define KBD_ENTROPY_DEV			0x0001
#define MOUSE_ENTROPY_DEV		0x0002

// instruct compiler to use inline version of function
#pragma intrinsic(memset)


//	Win9x-specific critical section structure
typedef struct {
	PVMMMUTEX	mutex;
} PGPDRIVERCRITICALSECTION;

//	driver context data structure
typedef struct {
	ULONG						ulStatusFlags;

	INT							iKBDCount;
	INT							iMouseCount;

	PGPDRIVERCRITICALSECTION	csInactivity;
	PGPDRIVERCRITICALSECTION	csCache;
	PGPDRIVERCRITICALSECTION	csEntropy;
	PGPDRIVERCRITICALSECTION	csMemlock;

	PGPINACTIVITY				inactivity;
	PGPCACHE					cacheSign;
	PGPCACHE					cacheDecrypt;
	PGPMEMLOCK					memlock;
} PGPUTILCONTEXT, *PPGPUTILCONTEXT;

// macros
//	PGPdbgPrint prints a message to the debugging console
#ifndef PGPdbgPrint
#if PGP_DEBUG
#define PGPdbgPrint(arg) Debug_Printf arg
#else
#define PGPdbgPrint(arg)
#endif

#if PGP_DEBUG && PGP_DEBUG_VERBOSE
#define PGPdbgVerbosePrint(arg)  Debug_Printf arg
#else
#define PGPdbgVerbosePrint(arg)
#endif
#endif

#endif //_pgpDriver9x_h
